/**
 * Корзина
 * @name euroBasket
 */
(function ($) {
    "use strict";

    var defaults = {
        basketsCount: 4 // Максимальное количество корзин, включая основную
    };
    var options;

    var methods = {
        init: function (params) {
            options = $.extend({}, defaults, params);
            return this.each(function () {
                var $this = $(this),
                    data = $this.data('eurobasket');

                if(!data) {
                    var $groups = $this.find('.basket');
                    $this.data('eurobasket', {
                        target: $this,
                        basketsCount: options.basketsCount,
                        baskets: $basket.length
                    });

                    $groups.each(function () {
                        var $basket = $(this),
                          basketData = $basket.data('basket');

                        if(!basketData) {
                            $basket.data('basket', {
                                target: $this,
                                name: 'name',
                                color: 'color',
                                products: 25
                            });
                        }
                    });
                }
            });
        },

        destroy: function () {
            return this.each(function () {
                var $this = $(this),
                  data = $this.data('eurobasket');

//                $(window).off('.euroBasket');
//                data.euroBasket.remove();
                $this.removeData('eurobasket');
                console.log('destroy end');
            });
        },

        update: function (data) {
            $(this).addClass('active');
            console.log($(this));
        },

        test: function () {
            methods.update({baskets: 5});
//            console.log($(this).data('eurobasket'));
//            methods.destroy();
//            console.log($(this).data('eurobasket'));
//            console.log(this);
        }
    };

    var privateMethods = {
        _update: function (el, data) {

        },

        _groupUpdate: function (el, data) {

        }
    };

    $.fn.euroBasket = function (method) {
        if (methods[method]) {
            return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
        } else if (typeof method == 'object' || !method) {
            return methods.init.apply(this, arguments);
        } else {
            $.error('Плагин применен с некорректными параметрами');
        }
    };

})(jQuery);