function isNumber(n) {
    return !isNaN(parseFloat(n)) && isFinite(n);
}

var Europarts = Europarts || {};

Europarts.navbarHeight = $('#h_navbar').height();

Europarts.subscribeTimeoutId;

// navbar dropdown hide
//Europarts.hideDropdown = function(current) {
//    $('#navbar li.dropdown.active').each(function() {
//        if (current && $(this).is(current)) return;
//
//        $('div.dropdown-list', this).hide();
//        $(this).removeClass('active');
//    });
//
//    $('div.catalogue-page div.catalogue-title.active').removeClass('active');
//    $('div.catalogue-page div.catalogue-title div.dropdown-list').hide();
//
//    $('div.search-history-box i.icon-help').removeClass('active');
//    $('div.search-history-box div.help-tooltip').hide();
//
//    // subscribe popup
//    $('div.subscribe-popup').hide();
//
//    // analogue popup
//    $('div.analogue-popup').hide();
//
//    // btn buy
//    $('div.btn-buy').removeClass('active');
//    $('div.btn-buy div.dropdown-list').hide();
//
//    // новая группа корзины
//    $('div.new-group').hide();
//    $('div.new-group div.colors-list').hide();
//
//    // order composition detail popup
//    $('#sidebar div.order-composition div.category-detail').hide();
//
//    // faq navigation
//    $('#faq_nav').removeClass('active');
//
//    // sidebar company ofices
//    $('div.opb-city-box').removeClass('active');
//    Europarts.hideSubscribeNotice();
//};

// navbar shipment notice
Europarts.showShipmentNotice = function() {
    var $shipmentCell = $('#navbar li.shipment'),
     $shipmentNotice = $('div.nav-shipment-notice'),
     leftOffset = $shipmentCell.offset().left + Math.round($shipmentCell.outerWidth(true) / 2) - Math.round($shipmentNotice.outerWidth(true) / 2);

    $('div.nav-shipment-notice').css({
        'left': leftOffset,
        'top': $('#navbar li.shipment').outerHeight(true)
    }).fadeIn();

    $('i.icon-close', $shipmentNotice).one('click', function() {
        $(this).parent().fadeOut();
    });
};

// всплывающая подсказка подписки
Europarts.hideSubscribeNotice = function() {
    $('div.subscribe-notice').hide();
}

// всплывающая заявка на отсутствующую деталь
Europarts.orderMissingItemPopup = function() {
    $('a[href="#order_missing_item_popup"]').on('click', function() {
        $('#order_missing_item_popup').dialog({
            modal: true,
            dialogClass: 'order-missing-item-popup',
            width: 490,
            open: function() {
                $('div.ui-widget-overlay').addClass('overlay-black-30')
                    .on('click', function() {
                        $('#order_missing_item_popup').dialog('close');
                    });
            },
            close: function() {
                $('div.ui-widget-overlay').removeClass('overlay-black-30');
            }
        });
    });
};

// карточка товара
// cart popup
Europarts.itemCartPopup = function() {
    $('div.table-body').on('click', 'div.model-article a', function(e) {
        e.preventDefault();

        var modelNumber = $(this).attr('href').replace('#model_', '');

        if (!isNumber(modelNumber)) {
            return;
        }

        $('#model_popup_' + modelNumber).dialog({
            modal: true,
            dialogClass: 'model-popup',
            width: '100%',
            open: function() {
                $('div.ui-widget-overlay').addClass('overlay-black-50')
                    .on('click', function() {
                        $('#model_popup_' + modelNumber).dialog('close');
                    });

                var $orderInfoSum = $('div.order-info-sum', this),
                  inCard = $orderInfoSum.hasClass('in-card');

                // model dialog keyup
                $('div.model-count input', this).on('keyup', function() {
                    var count = $(this).val();
                    if (!inCard && isNumber(count)) {
                        if (count > 1) {
                            $orderInfoSum.show();
                        } else {
                            $orderInfoSum.hide();
                        }
                    }

                });
            },
            close: function() {
                $('div.ui-widget-overlay').removeClass('overlay-black-50');
            }
        });
    });
};

// popup discounts tooltip
Europarts.discountsTooltipInPopup = function() {
    $('div.order-info span.counts-discount').tooltip({
        position: {
            my: "center bottom",
            at: "center top-5",
            using: function( position, feedback ) {
                $( this ).css( position );
                $( "<div>" )
                    .addClass( 'arrow' )
                    .addClass( feedback.vertical )
                    .addClass( feedback.horizontal )
                    .appendTo( this );
            }
        },
        tooltipClass: 'tooltip-simple',
        show: {
            delay: 300
        }
    });
};

// video dialog
//Europarts.videoPopup = function (link, popup) {
//    var selector = link || 'div.video-about',
//        popup = popup || '#video_popup';
//
//    $(selector).on('click', function (e) {
//        e.preventDefault();
//
//        $(popup).dialog({
//            modal: true,
//            dialogClass: 'video-popup',
//            width: 'auto',
//            open: function() {
//                $('div.ui-widget-overlay').addClass('video-overlay')
//                    .on('click', function() {
//                        $(popup).dialog('close');
//                    });
//
//                // fix for width:auto in IE
//                var contentWidth = $(this).outerWidth(true);
//                $(this).closest('.lt-ie8 div.ui-dialog').css({
//                    'width': contentWidth,
//                    'left': '50%',
//                    'margin-left': -(contentWidth / 2)
//                });
//            },
//            close: function() {
//                $('div.ui-widget-overlay').removeClass('video-overlay');
//
//                //fix for width:auto in IE
//                $(this).closest('.lt-ie8 div.ui-dialog').css('width', 'auto');
//            }
//        });
//    });
//};

// table discounts tooltip
Europarts.discountsTooltipInTable = function() {
    $('div.table span.counts-discount, div.table i.icon-percent').tooltip({
        position: {
            my: "right center",
            at: "left-10 center",
            using: function( position, feedback ) {
                $( this ).css( position );
                $( "<div>" )
                    .addClass( 'arrow' )
                    .addClass( feedback.vertical )
                    .addClass( feedback.horizontal )
                    .appendTo( this );
            }
        },
        tooltipClass: 'tooltip-simple',
        show: {
            delay: 300
        }
    });
};

// order composition detail popup
Europarts.orderCompositionDetail = function() {
    $('#sidebar div.order-composition ul.category-items').on('click', 'span.count', function(e) {
        Europarts.hideDropdown();
        e.stopPropagation();

        var $detail = $(this).parent('li').find('div.category-detail');

        if ($detail.is(':visible')) {
            return;
        }

        $detail.show()
            .one('click', 'i.icon-close', function(e) {
                e.stopPropagation();
                $detail.hide();
            });
    });
};

// faq right navigation
Europarts.faqNav = function () {
    $('#faq_nav').on('click', function (e) {
        e.stopPropagation();

        var $current = $('div.current', this),
            $target = $(e.target),
            $list = $('ul.dropdown-list', this);

        if ($target.is(':not(li.current)') && $target.is('li') || $list.has($target).length) {
            var $li = 0;

            if ($target.is('li')) {
                $li = $target;
            } else {
                $li = $target.parent('li');
            }

            $current.text($li.children().remove().end().text());
            $('li.current', this).removeClass('current');
            $li.addClass('current');
        }

        //if ($target.is($current) || $current.has($target).length || $target.is('li.current')) {
            $(this).toggleClass('active');
        //}
    });
};

// company warehouse google map
Europarts.gMapInit = function () {
    var title = $('#map_title').html();
    var latlng = new google.maps.LatLng(55.803992,37.748845);
    var myOptions = {
        zoom: 16,
        center: latlng,
        mapTypeId: google.maps.MapTypeId.ROADMAP,
        mapTypeControl: true,
        mapTypeControlOptions: {
            style: google.maps.MapTypeControlStyle.DROPDOWN_MENU
        },
        navigationControl: true,
        navigationControlOptions: {
            style: google.maps.NavigationControlStyle.SMALL
        }
    };
    var infowindow = new google.maps.InfoWindow({
        position: new google.maps.LatLng(55.8044,37.748845),
        content: title,
        maxWidth: 150
    });
    var map = new google.maps.Map(document.getElementById('map_canvas'), myOptions);
    var marker = new google.maps.Marker({
        position: latlng,
        map: map
    });
    google.maps.event.addListener(marker, 'click', function() {
        infowindow.open(map);
    });
    infowindow.open(map);
};

// company sidebar navigation
Europarts.companyNav = function () {
    $('#company_nav').on('click', 'div.company-subnav-link', function (e) {
        $(this).next('ul.company-subnav').toggle()
            .end()
            .parent('li').toggleClass('active');
    });
};

// sidebar company ofices phones
Europarts.oficesPhones = function () {
    var $cityBox = $('div.opb-city-box');

    // при клике по верхнему меню не срабатывает
    $(document).on('click', function() {
        if ($cityBox.is(':visible')) {
            $cityBox.removeClass('active');
        }
    });

    $cityBox.on('click', function (e) {
        e.stopPropagation();

        var $target = $(e.target),
            $label = $('span.opb-current-city-label');

        if ($target.is($label) || $label.has($target).length) {
            $(this).toggleClass('active');
            return;
        }

        if ($target.is('span.opb-city-link')) {
            $(this).removeClass('active');
            $('div.opb-body.active').removeClass('active');
            var idCity = $target.attr('id').replace('_link', '');
            $('#' + idCity).addClass('active');
            $('span.opb-current-city', this).text($target.attr('data-city'));
            $('span.opb-city-link.current', this).removeClass('current');
            $target.addClass('current');
        }
    });
};

// manager mail popup
Europarts.managerMailPopup = function (link, popup) {
    var popup = popup || '#manager_email_popup';

    $(link).on('click', function(e) {
        e.preventDefault();

        $(popup).dialog({
            modal: true,
            dialogClass: 'manager-email-popup',
            width: 650,
            open: function() {
                $('div.ui-widget-overlay').addClass('overlay-black-30')
                    .on('click', function() {
                        $(popup).dialog('close');
                    });
            },
            close: function() {
                $('div.ui-widget-overlay').removeClass('overlay-black-30');
            }
        });
    });
};

// manager mail success send popup
Europarts.successSendingPopup = function () {
    $('#success_registration_popup').dialog({
        modal: true,
        dialogClass: 'success-registration-popup',
        width: '452',
        minHeight: '50',
        open: function() {
            $('div.ui-widget-overlay').on('click', function() {
                $('#success_registration_popup').dialog('close');
            });

            $(this).parent('div.ui-dialog').find('button.ui-dialog-titlebar-close').hide();
        }
    });
};

// shopping cart tabs
Europarts.cartTabs = function () {
    var cartTabs = $('div.shopping-cart-tabs').tabs();

    // close icon: removing the tab on click
    cartTabs.delegate('i.icon-remove-tab', 'click', function () {
        if ($('div.remove-confirm-popup').length) {
            return;
        }

        var that = this,
            confirmPopup = '<div class="remove-confirm-popup"><i class="icon-close"></i><h3>Удалить эту корзину</h3>' +
            '<p>Все товары этой группы, включая саму группу будут удалены. Вы подтверждаете данную операцию?</p>' +
            '<button class="btn-remove">Удалить</button><em>или</em><span class="dotted-red">Отменить</span></div>';

        $(this).addClass('active')
            .after(confirmPopup);

        $('div.remove-confirm-popup').on('click', function (e) {
            var $target = $(e.target);

            if ($target.is('span.dotted-red') || $target.is('i.icon-close')) {
                $(that).removeClass('active');
                $(this).remove();
                return;
            }

            if ($target.is('button.btn-remove')) {
                var panelId = $(this).closest('li').remove().attr('aria-controls');

                $(that).removeClass('active');
                $(this).remove();

                $('#' + panelId).remove();
                cartTabs.tabs('refresh');
            }
        });


        // добавить кнопку добавления
        if ($('div.shopping-cart-tabs ul.ui-tabs-nav > li').length <= 4) {
            $('li.btn-add-tab').show();
        }
    });

    /*cartTabs.bind('keyup', function (e) {
        if (e.altKey && e.keyCode === $.ui.keyCode.BACKSPACE ) {
            var panelId = tabs.find('.ui-tabs-active').remove().attr('aria-controls');
            $('#' + panelId).remove();
            cartTabs.tabs('refresh');
        }
    });*/

    $('li.btn-add-tab').on('click', function(e) {
        $(this).addClass('active');
        $('div.new-group', this).show();
    });

    // add group submit
    $('li.btn-add-tab div.new-group form').on('submit', function (e) {
        e.preventDefault();

        var $target = $(e.target),
            name = $('#new_group_name').val(),
            bgColor = $('div.current-color').attr('class').split(' ')[1];

        if (name.length < 2) {
            return;
        }

        addTab(name, bgColor);
        $('li.btn-add-tab').removeClass('active');
        $('li.btn-add-tab div.new-group').hide();
    });

    function addTab(name, bgColor) {
        var counter = parseInt($('div.shopping-cart-tabs div.ui-tabs-panel:last').attr('id').replace('shopping_cart_', '')) + 1,
            id = 'shopping_cart_' + counter,
            tab = '<li><a href="#' + id + '"><div class="cart-tab-wrapper">' +
                '<span class="count badge ' + bgColor  + '">0</span><strong class="cart-tab-title">' + name + '</strong>' +
                '<div class="tab-text-overflow"></div></div><i class="icon-remove-tab"></i></a></li>';

        cartTabs.find('li.btn-add-tab').before(tab);
        cartTabs.append('<div id="' + id + '"></div>');

        if ($('div.shopping-cart-tabs ul.ui-tabs-nav > li').length >= 5) {
            $('li.btn-add-tab').hide();
        }

        cartTabs.tabs('refresh');
    }
};


$(function() {
    // hide popups/dropdown
    $(document).on('click', function() {
        // footer languages
//        $.dropDownMenu('hidePopups', $('.popup, .dropdown-list'), $('.btn-popup, .dropdown, .catalogue-title'));
        $.dropDownMenu('hideDropDown');
    });

//    $('.dropdown, .dropup, .catalogue-title, .btn-popup').dropDownMenu();
    $('.dropdown-toggle dropdown-switch').dropDownMenu();

    // показ большего числа брендов
    var $moreBrandsLink = $('.brands-list .more');
    $moreBrandsLink.on('click', function (e) {
        e.preventDefault();
        var $moreBrands = $('#more-brands'),
          $this = $(this),
          currentText = $this.text(),
          toggleText = $this.data('toggle-text');

        $moreBrands.stop(true, false).slideToggle();
        $this.text(toggleText).data('toggle-text', currentText);
    });


    // смена брендов
    var $brand = $('.brands-list span'),
      $brandHead = $('.catalogue-title-logo');

    $brand.on('click', function () {
        var $this = $(this),
          removedClass = $brandHead[0].className.match(/ logo-\w*/)[0],
          $dropdownList = $this.closest('.dropdown-list');
        if (!$this.hasClass('current')) {
            $brandHead
              .removeClass(removedClass)
              .addClass($this[0].className)
              .text($this.text());
            $brandHead.closest('.catalogue-title').removeClass('active');
            $dropdownList.hide();

            $dropdownList.find('.current').removeClass('current');
            $this.addClass('current');
        }
    });

    // смена категории
    var $category = $('.categories-list span'),
      $categoryHead = $('.category-title .title');

    $category.on('click', function () {
        var $this = $(this),
          $dropdownList = $this.closest('.dropdown-list');
        $categoryHead.text($this.text());
        $categoryHead.closest('.catalogue-title').removeClass('active');
        $dropdownList.hide();
        $dropdownList.find('.current').removeClass('current');
        $this.addClass('current');
    });

    $('#navbar li.messages').tooltip({
        position: {
            my: "center bottom",
            at: "center+10 top-10",
            using: function( position, feedback ) {
                $( this ).css( position );
                $( "<div>" )
                  .addClass( 'arrow' )
                  .addClass( feedback.vertical )
                  .addClass( feedback.horizontal )
                  .appendTo( this );
            }
        },
        tooltipClass: 'message-notice',
        show: {
            delay: 400
        }
    });

    //подсказки в карточке товара
    var $help = $('.model-info').find('.icon-help');
    $help.tooltip({
        position: {
            my: "left center",
            at: "right+8 center",
            using: function( position, feedback ) {
                $( this ).css( position );
                $( "<div>" )
                  .addClass( 'arrow' )
                  .addClass( feedback.vertical )
                  .addClass( feedback.horizontal )
                  .appendTo( this );
            }
        },
        tooltipClass: 'tooltip-simple',
        show: {
            delay: 300
        }
    });

//    // forgot password popup
//    $('a.forgot-password-link').on('click', function(e) {
//        $('#forgot_password_popup').dialog({
//            modal: true,
//            dialogClass: 'forgot-password-popup',
//            width: '390',
//            open: function() {
//                $('div.ui-widget-overlay').addClass('forgot-password-overlay')
//                    .on('click', function() {
//                        $('#forgot_password_popup').dialog('close');
//                    });
//
//                $('#forgot_password_popup input:text').focus();
//            },
//            close: function() {
//                $('div.ui-widget-overlay').removeClass('forgot-password-overlay');
//            }
//        });
//
//        e.preventDefault();
//    });



    // footer languages
//    $('#footer div.languages').on('click', function(e) {
//        e.stopPropagation();
//
//        var $languagesList = $('ul', this),
//            $target = $(e.target);
//
//        if ($languagesList.is(':hidden')) {
//            $('ul', this).show();
//        }
//
//        if ($target.is('li') || $target.is('li i')) {
//            var $activeLang;
//
//            if ($target.is('li')) {
//                var newLangClass = $target.find('i').attr('class');
//                $activeLang = $target;
//            } else if ($target.is('li i')) {
//                var newLangClass = $target.attr('class');
//                $activeLang = $target.parent();
//            }
//
//            $('div.current i', this).attr('class', newLangClass);
//            $languagesList.hide();
//            $languagesList.find('li.active').removeClass('active');
//            $activeLang.addClass('active');
//        }
//    });

    // input placeholder
    $('div.placeholder-input').each(function() {
        var $input = $('input, textarea', this),
            $label = $('label', this),
            $that = $(this);

        if (!$input.data('defaultValue')) {
            $input.data('defaultValue', $label.text());
        }

        if ('' != $input.val()) {
            $label.text('');
        }

        $input.on({
            focus: function() {
                $that.addClass('focus');
            },
            blur: function() {
                $that.removeClass('focus');
            },
            'keyup change': function() {
                if (0 < $(this).val().length) {
                    $label.text('');
                } else {
                    $label.text($(this).data('defaultValue'));
                }
            }
        });
    });

    // search
    $('#search input:text').on('focus', function() {
        $('#search .search-control .wrapper').addClass('active');
    }).on('blur', function() {
        $('#search .search-control .wrapper').removeClass('active');
    });

    // sidebar registration advantages
    $('#sidebar ul.advantage-items').on('click', 'div.header', function() {
        var $li = $(this).parent('li');

        if (!$li.hasClass('active')) {
            // hide other active
            $('#sidebar ul.advantage-items li.active div.body').slideUp('fast', function() {
                $(this).closest('li.active').removeClass('active');
            });
        }

        $(this).next('div.body').slideToggle('fast', function() {
            $li.toggleClass('active');
        });
    });

    // registration form
    $('div.registration-page input[data-required], div.order-payer input[data-required]').each(function() {
        var valid = true;

        if ('email' == $(this).attr('data-validate')) {
            valid = $(this).val().match(/.+@.+\..+/i);
        }

        if (valid && '' != $(this).val()) return;

        var $that = $(this),
            $link = $('<span>' + $(this).attr('data-required') + '</span>').on('click', function() {
                $('html, body').animate({ scrollTop: $that.offset().top - Europarts.navbarHeight }, 'slow', function() {
                    $that.trigger('focus');
                });
            });

        var $fieldsErrors = $('div.fields-errors'),
            $fieldsLinks = $('div.fields-errors div.fields');

        if ($fieldsErrors.is(':hidden')) {
            $fieldsErrors.show();
        }

        if ($fieldsLinks.children().length > 0) {
            $fieldsLinks.append(', ');
        }

        $fieldsLinks.append($link);
    });

    // collapse box
    $('div.collapse-box').on('click', function(e) {
        if (!$('div.collapse-link span.link', this).has($(e.target)).length) {
            return;
        }

        e.preventDefault();

        $(this).toggleClass('active');
        $('div.collapse-content', this).slideToggle('fast');
    });

    // sidebar search history box
    $('div.search-history-box')
      .on('click',function (e) {
          var $target = $(e.target);

          // свернуть/развернуть
          if ($('div.collapse-link').has($target).length) {
              var $textNode = $('div.collapse-link > span span', this),
                oldText = $textNode.text(),
                $additionalList = $('div.history-body ul li:gt(5)', this);

              if ($(this).hasClass('collapsed')) {
                  $additionalList.show();
              } else {
                  $additionalList.hide();
              }

              $(this).toggleClass('collapsed');
              $textNode.text($textNode.attr('data-toggle-text'));
              $textNode.attr('data-toggle-text', oldText);
              $('div.collapse-link i.arrow', this).toggleClass('up');
          }
      }).on('mouseenter', 'li', function () {
          var $modelDetail = $('div.model-detail', this),
            $this = $(this);
          $this.data('hover', true);
          setTimeout(function () {
              if ($this.data('hover')) {
                  $modelDetail.stop(true, true).show()
                    .css('margin-top', -($modelDetail.outerHeight() / 2));
              }
          }, 500);
      }).on('mouseleave', 'li', function () {
          $(this).data('hover', false);
          $('div.model-detail', this).hide();

      });

    $('.search-history-box').tooltip({
        position: {
            my: "left center",
            at: "left+24 center",
            using: function( position, feedback ) {
                $( this ).css( position );
                $( "<div>" )
                  .addClass( 'arrow' )
                  .addClass( feedback.vertical )
                  .addClass( feedback.horizontal )
                  .appendTo( this );
            }
        },
        tooltipClass: 'help-tooltip',
        show: {
            delay: 300
        }
    });

    // btn buy
    $('div.btn-buy').on('click', function(e) {
        Europarts.hideDropdown();
        e.stopPropagation();

        if ($(e.target).is('div.arrow-box') || $('div.arrow-box', this).has($(e.target)).length) {
            var $dropdownList = $('div.dropdown-list', this);

            if ($dropdownList.is(':hidden')) {
                $(this).addClass('active');
                $dropdownList.show();
            }
        }

        // новая группа корзины
        if ($(e.target).is('div.dropdown-list li.new a')) {
            e.preventDefault();

            // закрыть popup если нужно
            var $dialog;

            if (($dialog = $('div.ui-dialog-content')).is(':visible')) {
                $dialog.dialog('close');
            }

            $('#navbar div.new-group').show();
        }
    });

    // всплывающее окно подписки
    $('span.inform-on-stock span.dotted-blue-link, span.inform-on-stock.subscribed').on('click', function(e) {
        Europarts.hideDropdown();
        e.stopPropagation();

        var number,
            linkPos = $(this).offset();

        if ($(this).is('span.inform-on-stock')) {
            number = $(this).attr('data-stock-model');
        } else {
            number = $(this).parent('span.inform-on-stock').attr('data-stock-model');
        }

        var $popup = $('div.subscribe-popup[data-stock-model="' + number + '"]');

        $popup.css({
            left: Math.floor(linkPos.left - 40),
            top: Math.floor(linkPos.top - 118),
            display: 'block'
        }).on('click', function(e) {
            e.stopPropagation();

            if ($(e.target).is('i.icon-close')) {
                $popup.hide();
            }
        });
    });

    // всплывающая подсказка подписки
    $('span.inform-on-stock:not(".subscribed")').on('mouseenter', function(e) {
        var $popupNotice = $('div.subscribe-notice'),
            textOffset = $(this).offset();

        $popupNotice.show()
            .css({
                'left': textOffset.left + $(this).width() / 2,
                'top': textOffset.top - $popupNotice.outerHeight() - 5,
                'margin-left': -$popupNotice.outerWidth() / 2
            });

    }).on('mouseleave', function() {
        Europarts.subscribeTimeoutId = setTimeout(Europarts.hideSubscribeNotice, 1500);

        $('div.subscribe-notice').on('mouseenter', function() {
            clearTimeout(Europarts.subscribeTimeoutId);
        }).on('mouseleave', function() {
                Europarts.hideSubscribeNotice();
        }).on('click', 'span.dont-distrub', function() {
                Europarts.hideSubscribeNotice();
        });
    });

    // checkbox подписки
    $('div.switch').on('click', function(e) {
        var $target = $(e.target),
            $checkbox = $(':checkbox', this),
            $checkboxWrapper = $('span.switch-checkbox', this),
            $leftLabel = $('span.switch-label:first', this),
            $rightLabel = $('span.switch-checkbox + span.switch-label', this);

        if ($target.is($checkboxWrapper) || $target.is('span.switch-label:not(".active")')) {
            $checkbox.prop('checked', !$checkbox.prop('checked'));
            $checkboxWrapper.toggleClass('checked');
            $leftLabel.toggleClass('active');
            $rightLabel.toggleClass('active');
        }
    });

    // есть аналоги popup
    $('div.analogue span.dotted-blue-link').on('click', function(e) {
        Europarts.hideDropdown();
        e.stopPropagation();

        $('div.analogue-popup', this).show()
            .on('click', function(e) {
                e.stopPropagation();

                if ($(e.target).is('i.icon-close')) {
                    $(this).hide();
                }
            });
    });

    // новая группа корзины
    // выбор цвета
    $('div.new-group').on('click', function(e) {
        e.stopPropagation();

        var $target = $(e.target),
            $colorsList = $('div.colors-list', this);

        // btn cancel
        if ($target.is($('div.actions span.dotted-red', this)) || $target.is('i.icon-close')) {
            $(this).hide();

            var $addTab = $(this).closest('li.btn-add-tab.active');
            if ($addTab.length) {
                $addTab.removeClass('active');
            }

            return;
        }

        if (!$('div.color-box', this).has($target).length) {
            if ($colorsList.is(':visible')) {
                $colorsList.hide();
            }

            return;
        }

        var $currentColor = $('div.current-color', this);

        if ($target.is($currentColor)) {
            $colorsList.show();
        }

        if ($target.is('div.colors-list li:not(".active")', this)) {
            $currentColor[0].className = $currentColor[0].className.replace(/\bbg-.*\b/, $target.attr('class'));

            var $activeColor = $('div.colors-list li.active', this),
                $activeDiv = $('div', $activeColor);

            $activeColor.removeClass('active');
            $target.addClass('active');
            $target.append($activeDiv);
            $colorsList.hide();
        }
    });

    // количество символов
    $('div.new-group div.placeholder-input input').on('change keyup', function() {
        var maxLength = 22,
            lastChar = $(this).closest('div.row').find('div.hint span.chars');

        lastChar.text(maxLength - $(this).val().length);
    });

    // подходит к моделям
    $('div.models-compatible div.compatible-brands').on('click', 'span:not(".active")', function(e) {
        var brandName = /\bcompatible-.+\b/.exec($(this)[0].className)[0];

        if (!brandName) {
            return;
        }

        var $parent = $(this).closest('div.models-compatible');
        $('div.compatible-brands span', $parent).removeClass('active');
        $(this).addClass('active');
        $('div.compatible-models', $parent).removeClass('active');
        $('div.' + brandName + '-models', $parent).addClass('active');
    });

    // ie7 table row z-index
    var ie7TableRowZIndex = 50;

    $('.lt-ie8 div.table div.table-body div.table-row').each(function() {
        $(this).css('z-index', ie7TableRowZIndex);
        ie7TableRowZIndex -= 1;
    });

    $('.lt-ie8 #sidebar div.search-history-box').on('mouseenter', 'li', function() {
        $('#sidebar').css('z-index', '98');
    }).on('mouseleave', 'li', function() {
            $('#sidebar').css('z-index', '1');
    });

    // search functions
    $('#search_model').searchList();
//    $.dropDownMenu('hidePopups');

});
