;(function ( $, window, document, undefined ) {

    var pluginName = 'tooltipOnClick',
        defaults = {
            class: 'help-tooltip'
        };

    function Plugin( element, options ) {
        this.$element = $(element);

        this.options = $.extend( {}, defaults, options );

        this._defaults = defaults;
        this._name = pluginName;

        this.init();
    }

    Plugin.prototype = {

        init: function() {
            // показать подсказку при клике на иконке
            this.$element.on('click', $.proxy(this, 'show'));

            // удалить подсказку
            $(window).on('click', $.proxy(this.remove, this));

            this.$tooltip = $('<div class="' + this.options.class + '">' + this.$element.attr('data-tooltip-text') + '<i class="icon-close"></i></div>');

            var offset = this.$element.offset();
            this.top = offset.top;
            this.left = offset.left + 25;
        },

        show: function(e) {
            e.stopPropagation();

            var that = this;

            this.$tooltip.appendTo('body').show();

            switch (this.options.position) {
                case 'left':
                    this.left = this.$element.offset().left - this.$tooltip.innerWidth() - 8;
            }

            this.$tooltip.css({
                'position': 'absolute',
                'top': this.top,
                'left': this.left,
                'margin-top': -(this.$tooltip.outerHeight() / 2 - this.$element.outerHeight() / 2)
            })
            .on('click', function(e) {
                e.stopPropagation();

                if ($(e.target).is('i.icon-close')) {
                    that.remove();
                }
            });
        },

        remove: function() {
            this.$tooltip.remove();
        }
    };

    $.fn[pluginName] = function ( options ) {
        return this.each(function () {
            if (!$.data(this, "plugin_" + pluginName)) {
                $.data(this, "plugin_" + pluginName, new Plugin( this, options ));
            }
        });
    };

})( jQuery, window, document );