// Avoid `console` errors in browsers that lack a console.
(function() {
    var method;
    var noop = function () {};
    var methods = [
        'assert', 'clear', 'count', 'debug', 'dir', 'dirxml', 'error',
        'exception', 'group', 'groupCollapsed', 'groupEnd', 'info', 'log',
        'markTimeline', 'profile', 'profileEnd', 'table', 'time', 'timeEnd',
        'timeStamp', 'trace', 'warn'
    ];
    var length = methods.length;
    var console = (window.console = window.console || {});

    while (length--) {
        method = methods[length];

        // Only stub undefined methods.
        if (!console[method]) {
            console[method] = noop;
        }
    }
}());

/**
 * Подписка на уведомление о поступлении товара
 * @name showProduct
 */
(function ($) {
    var options = {};

    var methods = {
        init: function () {
            options.subscribePopup = $('#subscribe-popup');
            options.unsubscribePopup = $('#unsubscribe-popup');
            options.subscribeForm = options.subscribePopup.find('#subscribe-form');
            options.unsubscribeForm = options.unsubscribePopup.find('#unsubscribe-form');
            options.subscribePopup.dialog({
                autoOpen: false,
                modal: true,
                draggable: false,
                resizable: false,
                dialogClass: 'availability-popup',
                minHeight: 95,
                minWidth: 250,
                open: function () {
                    $('div.ui-widget-overlay')
                        .on('click', function() {
                            options.subscribePopup.dialog('close');
                        });
                    options.subscribeForm.on('submit', function (e) {
                        var $this = $(this);
                        methods.submitSubscribe(e, $this);
                    });
                },
                close: function () {
                    options.subscribeForm.off('submit');
                }
            });

            options.unsubscribePopup.dialog({
                autoOpen: false,
                modal: true,
                draggable: false,
                resizable: false,
                dialogClass: 'availability-popup',
                minHeight: 50,
                minWidth: 250,
                open: function () {
                    $('div.ui-widget-overlay')
                        .on('click', function() {
                            options.unsubscribePopup.dialog('close');
                        });
                    options.unsubscribeForm.on('submit', function (e) {
                        var $this = $(this);
                        methods.submitUnSubscribe(e, $this);
                    });
                },
                close: function () {
                    options.subscribeForm.off('submit');
                }
            });

            options.dontDistrub = $('#subscribe-notice').find('.dont-distrub');
            options.subscribeNotice = $('#subscribe-notice').dialog({
                autoOpen: false,
                modal: true,
                draggable: false,
                resizable: false,
                dialogClass: 'availability-notice-popup',
                minHeight: 80,
                minWidth: 250,
                open: function () {
                    $('div.ui-widget-overlay')
                        .on('click', function() {
                            options.subscribeNotice.dialog('close');
                        });
                    options.dontDistrub.on('click', function () {
                        methods.setCookie();
                    });
                },
                close: function () {
                    options.dontDistrub.off('click');
                }
            });
        },

        showSubscribe: function (id) {
            options.lastButton = this;
            options.subscribePopup.find('.model-id').val(id);
            options.subscribePopup.dialog('option', 'position', { my: "left-45 top-100%", at: "left top-8", of: options.lastButton });
            options.subscribePopup.dialog('open');
        },

        showUnSubscribe: function (id) {
            options.lastButton = this;
            options.unsubscribePopup.find('.model-id').val(id);
            options.unsubscribePopup.dialog('option', 'position', { my: "left-45 top-100%", at: "left top-8", of: options.lastButton });
            options.unsubscribePopup.dialog('open');
        },

        submitSubscribe: function (event, form) {
            event.preventDefault();
            var data = form.serialize();
            // аяксим запрос на подписку
            // после успешного ответа показываем окно уведомления (если не было отказа)

            methods.hideDialog();

            if (!$.cookie('dontShowNotice')) { // если юзер ранее не отказался от таких уведомлений
                options.subscribeNotice.dialog('option', 'position', { my: "center top-100%", at: "center top-8", of: options.lastButton });
                options.subscribeNotice.dialog('open');
            }

            // меняем контент кнопки
            var subscribed = $('<span />', {
                class: 'dotted-green-link subscribed-report',
                text: 'Оформлена подписка'
            }).data('stock-model', options.lastButton.data('stock-model'));
            options.lastButton.closest('.inform-on-stock').addClass('subscribed').empty().append('<i class="icon-checked-green"></i>').append(subscribed);
        },

        submitUnSubscribe: function (event, form) {
            event.preventDefault();
            var data = form.serialize();
            // аяксим запрос на подписку
            // после успешного ответа показываем окно уведомления (если не было отказа)

            methods.hideDialog();

            // меняем контент кнопки
            var subscribe = $('<span />', {
                class: 'dotted-blue-link availability-report',
                text: 'Сообщить'
            }).data('stock-model', options.lastButton.data('stock-model'));
            options.lastButton.closest('.inform-on-stock').removeClass('subscribed').empty().append(subscribe).append(' о поступлении на склад');
        },

        setCookie: function () {
            $.cookie('dontShowNotice', true);
            options.subscribeNotice.dialog('close');
        },

        hideDialog: function () {
            options.subscribePopup.dialog('close');
            options.unsubscribePopup.dialog('close');
        }
    };

    $.fn.availabilityReport = function (method) {
        if (methods[method]) {
            return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
        } else if (typeof method == 'object' || !method) {
            return methods.init.apply(this, arguments);
        } else {
            $.error('Плагин применен с некорректными параметрами');
        }
    };
    $.availabilityReport = function (method) {
        if (methods[method]) {
            return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
        } else if (typeof method == 'object' || !method) {
            return methods.init.apply(this, arguments);
        } else {
            $.error('Плагин применен с некорректными параметрами');
        }
    };
})(jQuery);

/**
 * Плагин searchList. Поиск по элементу в DOM набора символов, вводимых в поле input
 *
 * */
(function ($) {
    /**
     * Параметры по умолчанию
     * @field
     * @type {{inputWrapper: string, searchResult: string, listItems: string, event: string}}
     */
    var defaults = {
          inputWrapper: '#model-search',
          searchResult: '#search-result',
          listItems: '.result-item',
          event: 'keyup'
      };
    /**
     * Объект для параметров
     * @private
     * @field
     * @type {object}
     */
    var options = {};
    /**
     * Счетчик найденых результатов
     * @private
     * @field
     * @type {number}
     */
    var foundedCount = 0;

    /**
     * Паблик методы плагина
     * @public
     * @type {{init: Function, search: Function, hideTooltip: Function, inputClear: Function}}
     */
    var methods = {
        /**
         *
         * @param {object} params
         */
        init: function (params) {
            options = $.extend({}, defaults, params);

            var $input = $(this),
              $result = $(options.searchResult),
              $listItem = $result.find(options.listItems),
              $searchIn = $result.find('.for-search'),
              $closeBtn = $(options.inputWrapper).find('.icon-replace');

            $input
              .on(options.event + ' change', function () {
                  var filter = $input.val();
                  methods.search(filter, $searchIn, $listItem);
                  methods.hideTooltip($input);
              });

            $closeBtn.on('click', function () {
                methods.inputClear($input);
            });
        },

        /**
         *
         * @param {string} filter Строка поиска
         * @param {jQuery} $items Элементы, в которых проводится поиск
         * @param {jQuery} $listItems Родительский элемент для мест поиска
         */
        search: function (filter, $items, $listItems) {
            if (filter) {
                foundedCount = 0;
                $items.each(function () {
                    var matches = privateMethods._contains($(this)[0], filter);
                    if (matches) {
                        var $this = $(this),
                          innerText = $this[0].textContent || $this[0].innerText || '',
                          searchString = new RegExp('(' + filter + ')', 'ig');
                        $this.html(innerText.replace(searchString, '<span class="highlight">$1</span>'));
                        $this.closest(options.listItems).stop(true, true).slideDown();
                        foundedCount++;
                    } else {
                        $(this).closest(options.listItems).stop(true, true).slideUp();
                    }
                });
            } else {
                $items.each(function () {
                    var innerText = $(this)[0].textContent || $(this)[0].innerText || '';
                    $(this).html(innerText);
                });
                $listItems.slideDown();
            }
        },

        /**
         * Показ подсказки или кнопки очистки поля
         * @param {jQuery} $input
         */
        hideTooltip: function ($input) {
            var value = $input.val(),
              $inputWrapper = $(options.inputWrapper),
              $tooltip = $inputWrapper.find('.search-notice'),
              $closeBtn = $inputWrapper.find('.icon-replace'),
              $countWrapper = $inputWrapper.find('.found-count'),
              $counter = $inputWrapper.find('#found-counter');

            if (value.length > 0) {
                $tooltip.hide();
                $closeBtn.show();
                $counter.text(foundedCount);
                $countWrapper.show();
            } else {
                $tooltip.show();
                $closeBtn.hide();
                $countWrapper.hide();
                $counter.empty();
            }
        },

        /**
         * Очистка поля ввода текста
         * @param {jQuery} $input
         */
        inputClear: function ($input) {
            $input.val('').change();
        }
    };

    /**
     * @private
     * @inner
     * @type {{_contains: Function}}
     */
    var privateMethods = {
        _contains: function (field, filter) {
            return  (field.textContent || field.innerText || '').toLowerCase().indexOf(filter.toLowerCase()) >= 0;
        }
    };

    $.fn.searchList = function (method) {
        if (methods[method]) {
            return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
        } else if (typeof method == 'object' || !method) {
            return methods.init.apply(this, arguments);
        } else {
            $.error('Плагин применен с некорректными параметрами');
        }
    };
}(jQuery));


/**
 * показ выпадающих меню
 * @name dropDownMenu
 */
(function ($) {
    var defaults = {
          popupWrapper: 'dropdown', // Класс обертки для кнопки и попапа
          popupBtn: 'dropdown-switch', // Класс для кнопки вызова попапа
          popupClass: 'dropdown-panel', // Класс для попапов
          shipmentClass: 'nav-shipment-notice', // Класс для подсказки отгрузок
          basketCreate: 'new-group' // Класс для подсказки отгрузок
      },
      options = {};


    var methods = {
        init: function (params) {
            options = $.extend({}, defaults, params);

            options.wrapper = privateMethods._checkType(options.popupWrapper, '.', defaults.popupWrapper);
            options.btn = privateMethods._checkType(options.popupBtn, '.', defaults.popupBtn);
            options.popup = privateMethods._checkType(options.popupClass, '.', defaults.popupClass);

            options.btn.on('click', function (e) {
                var $btn = $(this),
                  $wrapper, $popup;

                if ($btn.closest('.brand-title').length > 0) {
                    $wrapper = $btn.closest('.brand-title');
                    $popup = $wrapper.find(privateMethods._checkType(options.popupClass, '.', defaults.popupClass));
                } else if ($btn.closest('.category-title').length > 0) {
                    $wrapper = $btn.closest('.category-title');
                    $popup = $wrapper.find(privateMethods._checkType(options.popupClass, '.', defaults.popupClass));
                } else {
                    $wrapper = $btn.closest(privateMethods._checkType(options.popupWrapper, '.', defaults.popupWrapper));
                    $popup = $wrapper.find(privateMethods._checkType(options.popupClass, '.', defaults.popupClass));
                }

                e.stopPropagation();
                methods.showDropDown($btn, $popup);
            });
        },

        /**
         * Показ всплывающего меню
         * @param {jQuery} $btn Кнопка триггер для показа меню
         * @param {jQuery} $popup Попап блок меню
         * @param {object} params Дополнительные параметры
         */
        showDropDown: function ($btn, $popup, params) {
            privateMethods._init(params);

            $popup.on('click', function (e) {
                e.stopPropagation()
            });

            if ($popup.is(':hidden')) {
                methods.hideDropDown(null);
                $btn.addClass('active');
                $popup.show();

                var popupPosition = $popup.data('popup-position') || 'none';
                switch (popupPosition) {
                    case 'center':
                        privateMethods._centeredPopup($btn, $popup);
                        break;

                    case 'left':
                        privateMethods._toLeftPopup($btn, $popup);
                        break;

                    case 'right':
                        privateMethods._toRightPopup($btn, $popup);
                        break;

                    case 'none':
                        break;
                }

                var triangleLeftPosition,
                  $triangle = $popup.find('span.before');

                if ($btn.closest('.category-title').length) {
                    triangleLeftPosition = ($btn.outerWidth(true) / 2) + $('.catalogue-page .brand-title').outerWidth(true);
                } else if ($btn.closest('.brand-title').length) {
                    triangleLeftPosition = $('.catalogue-page .catalogue-title-logo').outerWidth(true) / 2 - 8;// 8 = arrow width / 2
                }

                if ($triangle.length) {
                    $triangle.css('left', triangleLeftPosition)
                } else {
                    $popup.append('<span class="before" style="left: ' + triangleLeftPosition + 'px;"></span>');
                }
            } else {
                methods.hideDropDown(null);
            }
        },

        /**
         * Скрытие всех попап меню
         * @param {null|object} params
         */
        hideDropDown: function (params) {
            privateMethods._init(params);
            var $hideEl = $('.' + options.popupClass),
              $hideBtn = $('.' + options.popupBtn);
//              $hideShipment = $('.' + options.shipmentClass),
//              $basketCreate = $('.' + options.basketCreate);

            $hideEl.hide();
            $('.' + options.shipmentClass + ', .' + options.basketCreate + ', .payment-types-dropdown').hide();
            $hideBtn.removeClass('active');
        }
    };

    var privateMethods = {
        /**
         * Инициализация options, если метод вызван извне
         * @param {object} params
         * @private
         */
        _init: function (params) {
            if (privateMethods._emptyOptions()) {
                options = $.extend({}, defaults, params);

                options.wrapper = privateMethods._checkType(options.popupWrapper, '.', defaults.popupWrapper);
                options.btn = privateMethods._checkType(options.popupBtn, '.', defaults.popupBtn);
                options.popup = privateMethods._checkType(options.popupClass, '.', defaults.popupClass);
            }
        },

        /**
         * Проверка входного параметра (объект jQuery, строка). Если строка,
         * возвращаем объект с селектором по полученному типу
         *
         * @param {jQuery|string} el Проверяемый элемент
         * @param {string} type Тип селектора
         * @param {string} def Значение по умолчанию
         * @returns {jQuery}
         * @private
         */
        _checkType: function (el, type, def) {
            var $return = null;
            if (typeof el === 'object') {
                $return = el;
            } else if (typeof el === 'string') {
                if (el.charAt(0) === '.' || el.charAt(0) === '#') {
//                    el = el.substr(0);
                    return $(el);
                }
                $return = $(type + el);
            } else {
                $return = $(type + def);
            }
            return $return;
        },

        /**
         * Проверка объекта options на наличие в нем свойств
         * @returns {boolean}
         * @private
         */
        _emptyOptions: function () {
            for (var i in options) {
                return false;
            }
            return true;
        },

        _centeredPopup: function ($btn, $popup) {
            var leftOffset = Math.round( ($btn.outerWidth(true) - $popup.outerWidth(true)) / 2 );
            $popup.css('left', leftOffset);
        },

        _toLeftPopup: function ($btn, $popup) {
            $popup.css({
                'left': 0,
                'right': 'auto'
            });
        },

        _toRightPopup: function ($btn, $popup) {
            $popup.css({
                'right': 0,
                'left': 'auto'
            });
        }
    };

    $.fn.dropDownMenu = function (method) {
        if (methods[method]) {
            return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
        } else if (typeof method == 'object' || !method) {
            return methods.init.apply(this, arguments);
        } else {
            $.error('Плагин применен с некорректными параметрами');
        }
    };

    $.dropDownMenu = function (method) {
        if (methods[method]) {
            return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
        } else if (typeof method == 'object' || !method) {
            return methods.init.apply(this, arguments);
        } else {
            $.error('Плагин применен с некорректными параметрами');
        }
    };
})(jQuery);

/**
 * Меню на странице faq
 * @name faqScrollSpy
 */
(function ($) {

    var positions = new Array(),
      $menuLinks,
      $ScrollSpyMenu;

    var methods = {
        /**
         * Инициализация
         */
        init: function () {
            $ScrollSpyMenu = $('#scroll-spy-menu');
            var data = $ScrollSpyMenu.data('faqScrollSpy'),
              $faqSection = this;

            $(window).load(function () {
                if (!data) {
                    $ScrollSpyMenu.data('faqScrollSpy', true);
                    $faqSection.each(function () {
                        var $this = $(this),
                          articleCount = $this.find('.faq-article').length;
                        if ($this.data('faq-id')) {
                            $this.attr('id', 'section-' + $this.data('faq-id'));
                            positions['section-' + $this.data('faq-id')] = privateMethods._getPosition($this);
                            var $counter = $('<span />', {
                                class: 'count',
                                text: articleCount
                            });
                            var $menuLi = $('<li />', {
                                id: 'link-section-' + $this.data('faq-id'),
                                text: $this.data('faq-title')
                            }).data({
                                  target: 'section-' + $this.data('faq-id')
                              });

                            $menuLi.prepend($counter);
                            $ScrollSpyMenu.append($menuLi);
                        }
                    });
                }

                $menuLinks = $ScrollSpyMenu.find('li');
                $menuLinks.eq(0).addClass('current');

                privateMethods._checkScroll();

                $(window).resize(function () {
                    positions = [];
                    $faqSection.each(function () {
                        if ($(this).data('faq-id')) {
                            positions['section-' + $(this).data('faq-id')] = privateMethods._getPosition($(this));
                        }
                    });
                });

                $ScrollSpyMenu
                  .on('click', 'li', function () {
                      var $this = $(this);
                      if (!$this.hasClass('current')) {
                          privateMethods._linkDisactive($menuLinks);
                          privateMethods._linkActive($this);
                          privateMethods._slideTo($('#' + $this.data('target')));
                      }
                  });
            });
        }
    };

    var privateMethods = {
        /**
         * Скролл к элементу el
         * @param {jQuery} el
         * @private
         */
        _slideTo: function (el) {
            var slideSize = privateMethods._getPosition(el) - 50;
            $('html, body').stop(true, false).animate({
                scrollTop: slideSize
            }, 1000);
        },

        /**
         * Позиция жлемента на странице
         * @param {jQuery}
         * @returns {int}
         * @private
         */
        _getPosition: function (el) {
            return el.offset().top;
        },

        /**
         * Активная ссылка
         * @param {jQuery} $link
         * @private
         */
        _linkActive: function ($link) {
            $link.addClass('current');
        },

        /**
         * Потеря активности ссылки
         * @param $link
         * @private
         */
        _linkDisactive: function ($link) {
            $link.removeClass('current');
        },

        /**
         * Слушаем скролл страницы
         * @private
         */
        _checkScroll: function () {
            $(window).scroll(function () {
                var $scrollTop = $(window).scrollTop();

                if(!$('html, body').is(':animated')) {
                    privateMethods._scrollToMenu($scrollTop);
                }
            });
        },

        /**
         * Изменение активного пункта меню в зависимости от положения скролла на странице
         * @param $scrollTop
         * @private
         */
        _scrollToMenu: function ($scrollTop) {
            var currentPage = '';

            for (var key in positions) {
                if($scrollTop + 55 > positions[key]) {
                    currentPage = key;
                }
            }

            if (currentPage) {
                var $link = $ScrollSpyMenu.find('#link-' + currentPage);
                privateMethods._linkDisactive($menuLinks);
                privateMethods._linkActive($link);
            } else {
                privateMethods._linkDisactive($menuLinks);
                privateMethods._linkActive($ScrollSpyMenu.find('li:eq(0)'));
            }
        }
    };

    $.fn.faqScrollSpy = function (method) {
        if (methods[method]) {
            return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
        } else if (typeof method == 'object' || !method) {
            return methods.init.apply(this, arguments);
        } else {
            $.error('Плагин применен с некорректными параметрами');
        }
    };
})(jQuery);
// Place any jQuery/helper plugins in here.
