;(function($, window, document, undefined) {

    'use strict';

    var pluginName = "banners",
        defaults = {};

    function Plugin( element, options ) {
        this.$element = $(element);
        
        // $.extend копирует атрибуты из одного объекта в другой
        this.options = $.extend( {}, defaults, options );

        this._defaults = defaults;
        this._name = pluginName;

        this.init();
    }

    Plugin.prototype = {

        init: function() {
            // массив смещений при нажатии кнопок влево/вправо
            this.startPosition = 44;// выравнивание по контенту 60 - 16
            this.positions = [this.startPosition];
            // текущая позиция смещения
            this.position = 0;
            // ширина ul
            this.bannersWidth = 0;
            // текущая ширина окна для отслеживания изменений ширины окна
            this.windowWidth = $(window).width();
            // анимация закончена, чтоб нельзя было быстро кликать
            this.ready = true;
            this.intervalId;
            this.interval = 5000;

            var that = this;

            var bannersLength = $('div.slides li', this.$element).length;
            this.bannerWidth = $('div.slides li', this.$element).outerWidth(true);

            this.bannersWidth = bannersLength * this.bannerWidth;

            $('div.slides ul', this.$element).width(this.bannersWidth);

            // повтор
            if (this.windowWidth > this.bannersWidth) {
                this.$element.width(this.bannersWidth);
            } else {
                this.$element.width(this.windowWidth);
            }

            // нижняя навигация и смещения
            this.calcNav();
            
            // при изменении ширины окна изменить ширину галлереи
            $(window).on({
                resize:  $.proxy(this.resize, this),
                focus: $.proxy(this.cycle, this),
                blur: $.proxy(this.pause, this)
            });
            
            // кнопки вперед/назад если есть непоместишиеся картинки
            this.$btnNext = $('div.btn-next', this.$element).on({ click: $.proxy(this, 'next') });
            this.$btnPrev = $('div.btn-prev', this.$element).on({ click: $.proxy(this, 'prev') });
            
            if (this.bannersWidth > this.windowWidth) {
                this.$btnNext.show();
            }

            $('div.slides', this.$element).on({
                mouseenter: $.proxy(this.pause, this),
                mouseleave: $.proxy(this.cycle, this)
            });

            $('div.slides ul', this.$element).css('left', this.positions[this.position]);

            this.cycle();
        },
        
        next: function() {
            if (!this.ready) {
                return;
            }

            this.position += 1;
            this.go();
        },
        
        prev: function() {
            if (!this.ready) {
                return;
            }

            this.position -= 1;
            this.go();
        },
        
        go: function() {
            this.ready = false;
            var that = this;

            // если нельзя на столько пролестнуть
            if (0 > this.position) {
                this.position = this.maxPosition;
            }

            if (this.position > this.maxPosition) {
                this.position = 0;
            }

            $('div.slides ul', this.$element).animate({left: this.positions[this.position]}, 500, function() {
                $('span', that.$bannersNav).removeClass('active');
                $('span', that.$bannersNav).eq(that.position).addClass('active');

                // управление отображением кнопок
                if (that.position > 0) {
                    that.$btnPrev.show();
                } else {
                    that.$btnPrev.hide();
                }

                if (that.position < that.maxPosition) {
                    that.$btnNext.show();
                } else {
                    that.$btnNext.hide();
                }

                that.ready = true;
            });
        },

        cycle: function() {
            clearInterval(this.intervalId);

            // автопрокрутка имеет смысл если слайды не помещаются в окно
            if (this.bannersWidth > this.windowWidth) {
                this.intervalId = setInterval($.proxy(this.next, this), this.interval);
            }
        },

        pause: function() {
            clearInterval(this.intervalId);
        },

        // нижняя навигация и смещения
        calcNav: function() {
            $('div.banners-nav', this.$element).remove();

            this.positions = [this.startPosition];
            this.position = 0;
            this.$bannersNav = $('<div class="banners-nav"></div>');

            var bottomLinksLength = Math.ceil(this.bannersWidth / this.windowWidth),
                that = this;

            if (bottomLinksLength > 1) {
                // узнать на сколько перелистывать
                var stepWidth = Math.floor(this.windowWidth / this.bannerWidth) * this.bannerWidth;


                for (var i = 0; i < bottomLinksLength; i++) {
                    if (i > 0) {
                        var tmpOffset = stepWidth * i;

                        if (this.bannersWidth - tmpOffset >= this.windowWidth) {
                            this.positions[i] = -tmpOffset;
                        } else {
                            this.positions[i] = -(this.bannersWidth - this.windowWidth);
                        }
                    }

                    (function(i) {
                        $('<span></span>').on('click', function() {
                            that.position = i;
                            that.go();
                        }).appendTo(that.$bannersNav);
                    })(i);
                }
            }

            this.maxPosition = this.positions.length - 1;
            $(':first-child', this.$bannersNav).addClass('active');
            this.$element.append(this.$bannersNav);
        },

        resize: function() {
            var newWindowWidth = $(window).width();
                
            if (this.windowWidth == newWindowWidth) return;

            this.windowWidth = newWindowWidth;

            // нижняя навигация и смещения
            this.calcNav();

            // повтор
            if (this.windowWidth > this.bannersWidth) {
                this.$element.width(this.bannersWidth);
            } else {
                this.$element.width(this.windowWidth);
            }

            $('div.slides ul', this.$element).css('left', this.positions[this.position]);

            // проверить, нужна ли кнопка next
            if (this.bannersWidth > this.windowWidth) {
                this.$btnNext.show();
            } else {
                this.$btnNext.hide();
            }

            this.$btnPrev.hide();

            this.cycle();
        }
    };

    $.fn[pluginName] = function ( options ) {
        return this.each(function () {
            if (!$.data(this, "plugin_" + pluginName)) {
                $.data(this, "plugin_" + pluginName, new Plugin( this, options ));
            }
        });
    };
    
})(jQuery, window, document);