function isNumber(n) {
    return !isNaN(parseFloat(n)) && isFinite(n);
}

var Europarts = Europarts || {};

Europarts.showShipmentNotice = function() {
    var $shipmentCell = $('#navbar li.shipment'),
      $shipmentNotice = $('div.nav-shipment-notice'),
      leftOffset = $shipmentCell.offset().left + Math.round($shipmentCell.outerWidth(true) / 2) - Math.round($shipmentNotice.outerWidth(true) / 2);

    $('div.nav-shipment-notice').css({
        'left': leftOffset,
        'top': $('#navbar li.shipment').outerHeight(true)
    }).fadeIn();

    $('i.icon-close', $shipmentNotice).one('click', function() {
        $(this).parent().fadeOut();
    });
};

// shopping cart tabs
Europarts.cartTabs = function () {
    // sticky подключаю тут, так как offset().top неправильно вычисляется
    var cartTabs = $('div.shopping-cart-tabs').tabs({
        create: function(event, ui) {
            $('div.sticky', ui.panel).sticky();
        },
        activate: function( event, ui ) {
            $('div.sticky', ui.newPanel).sticky();
        }
    });

    // close icon: removing the tab on click
    cartTabs.delegate('i.icon-remove-tab', 'click', function () {
        if ($('div.remove-confirm-popup').length) {
            return;
        }

        var that = this,
            confirmPopup = '<div class="remove-confirm-popup"><i class="icon-close"></i><h3>Удалить эту корзину</h3>' +
                '<p>Все товары этой группы, включая саму группу будут удалены. Вы подтверждаете данную операцию?</p>' +
                '<button class="btn-remove">Удалить</button><em>или</em><span class="dotted-red">Отменить</span></div>';

        $(this).addClass('active')
            .after(confirmPopup);

        $('div.remove-confirm-popup').on('click', function (e) {
            var $target = $(e.target);

            if ($target.is('span.dotted-red') || $target.is('i.icon-close')) {
                $(that).removeClass('active');
                $(this).remove();
                return;
            }

            if ($target.is('button.btn-remove')) {
                var panelId = $(this).closest('li').remove().attr('aria-controls');

                $(that).removeClass('active');
                $(this).remove();

                $('#' + panelId).remove();
                cartTabs.tabs('refresh');
            }
        });


        // добавить кнопку добавления
        if ($('div.shopping-cart-tabs ul.ui-tabs-nav > li').length <= 4) {
            $('li.btn-add-tab').show();
        }
    });

    /*cartTabs.bind('keyup', function (e) {
     if (e.altKey && e.keyCode === $.ui.keyCode.BACKSPACE ) {
     var panelId = tabs.find('.ui-tabs-active').remove().attr('aria-controls');
     $('#' + panelId).remove();
     cartTabs.tabs('refresh');
     }
     });*/

    // add group submit
    $('li.btn-add-tab div.new-group form').on('submit', function (e) {
        e.preventDefault();

        var $target = $(e.target),
            name = $('#new_group_name').val(),
            bgColor = $('div.current-color').attr('class').split(' ')[1];

        if (name.length < 2) {
            return;
        }

        addTab(name, bgColor);
        $('li.btn-add-tab').removeClass('active');
        $('li.btn-add-tab div.new-group').hide();
    });

    function addTab(name, bgColor) {
        var counter = parseInt($('div.shopping-cart-tabs div.ui-tabs-panel:last').attr('id').replace('shopping_cart_', '')) + 1,
            id = 'shopping_cart_' + counter,
            tab = '<li><a href="#' + id + '"><div class="cart-tab-wrapper">' +
                '<span class="count badge ' + bgColor  + '">0</span><strong class="cart-tab-title">' + name + '</strong>' +
                '<div class="tab-text-overflow"></div></div><i class="icon-remove-tab"></i></a></li>';

        cartTabs.find('li.btn-add-tab').before(tab);
        cartTabs.append('<div id="' + id + '"></div>');

        if ($('div.shopping-cart-tabs ul.ui-tabs-nav > li').length >= 5) {
            $('li.btn-add-tab').hide();
        }

        cartTabs.tabs('refresh');
    }
};

// всплывающая заявка на отсутствующую деталь
Europarts.orderMissingItemPopup = function() {
    $('a[href="#order_missing_item_popup"]').on('click', function(e) {
        e.preventDefault();
        $('#order_missing_item_popup').dialog({
            modal: true,
            dialogClass: 'order-missing-item-popup',
            width: 490,
            open: function() {
                $('div.ui-widget-overlay').addClass('overlay-black-30')
                  .on('click', function() {
                      $('#order_missing_item_popup').dialog('close');
                  });
            },
            close: function() {
                $('div.ui-widget-overlay').removeClass('overlay-black-30');
            }
        });
    });
};

// карточка товара
// cart popup
Europarts.itemCartPopup = function() {
    $('div.table-body').on('click', 'div.model-article a', function(e) {
        e.preventDefault();

        var modelNumber = $(this).attr('href').replace('#model_', '');

        if (!isNumber(modelNumber)) {
            return;
        }

        $('#model_popup_' + modelNumber).dialog({
            modal: true,
            dialogClass: 'model-popup',
            resizable: false,
            width: '100%',
            open: function() {
                $('div.ui-widget-overlay').addClass('overlay-black-50')
                  .on('click', function() {
                      $('#model_popup_' + modelNumber).dialog('close');
                  });

                var $orderInfoSum = $('div.order-info-sum', this),
                  inCard = $orderInfoSum.hasClass('in-card');

                // model dialog keyup
                $('div.model-count input', this).on('keyup', function() {
                    var count = $(this).val();
                    if (!inCard && isNumber(count)) {
                        if (count > 1) {
                            $orderInfoSum.show();
                        } else {
                            $orderInfoSum.hide();
                        }
                    }

                });
            },
            close: function() {
                $('div.ui-widget-overlay').removeClass('overlay-black-50');
            }
        });
    });
};

// company warehouse google map
Europarts.gMapInit = function () {
    var title = $('#map_title').html();
    var latlng = new google.maps.LatLng(55.803992,37.748845);
    var myOptions = {
        zoom: 16,
        center: latlng,
        mapTypeId: google.maps.MapTypeId.ROADMAP,
        mapTypeControl: true,
        mapTypeControlOptions: {
            style: google.maps.MapTypeControlStyle.DROPDOWN_MENU
        },
        navigationControl: true,
        navigationControlOptions: {
            style: google.maps.NavigationControlStyle.SMALL
        }
    };
    var infowindow = new google.maps.InfoWindow({
        position: new google.maps.LatLng(55.8044,37.748845),
        content: title,
        maxWidth: 150
    });
    var map = new google.maps.Map(document.getElementById('map_canvas'), myOptions);
    var marker = new google.maps.Marker({
        position: latlng,
        map: map
    });
    google.maps.event.addListener(marker, 'click', function() {
        infowindow.open(map);
    });
    infowindow.open(map);
};

// company sidebar navigation
Europarts.companyNav = function () {
    $('#company_nav').on('click', 'div.company-subnav-link', function (e) {
        $(this).next('ul.company-subnav').toggle()
          .end()
          .parent('li').toggleClass('active');
    });
};

// manager mail popup
Europarts.managerMailPopup = function (link, popup) {
    var popup = popup || '#manager_email_popup';

    $(link).on('click', function(e) {
        e.preventDefault();

        $(popup).dialog({
            modal: true,
            dialogClass: 'manager-email-popup',
            width: 650,
            open: function() {
                $('div.ui-widget-overlay').addClass('overlay-black-30')
                  .on('click', function() {
                      $(popup).dialog('close');
                  });
            },
            close: function() {
                $('div.ui-widget-overlay').removeClass('overlay-black-30');
            }
        });
    });
};

// manager mail success send popup
Europarts.successSendingPopup = function () {
    $('#success_registration_popup').dialog({
        modal: true,
        dialogClass: 'success-registration-popup',
        width: '452',
        minHeight: '50',
        open: function() {
            $('div.ui-widget-overlay').on('click', function() {
                $('#success_registration_popup').dialog('close');
            });

            $(this).parent('div.ui-dialog').find('button.ui-dialog-titlebar-close').hide();
        }
    });
};

$(function () {
    'use strict';
    $(document).on('click', function () {
        $.dropDownMenu('hideDropDown');
    });
    $('.dropdown-switch').dropDownMenu();

    // показ большего числа брендов (index page)
    var $moreBrandsLink = $('.brands-list .more');
    $moreBrandsLink.on('click', function (e) {
        e.preventDefault();
        var $moreBrands = $('#more-brands'), $this = $(this), currentText = $this.text(), toggleText = $this.data('toggle-text');

        $moreBrands.stop(true, false).slideToggle();
        $this.text(toggleText).data('toggle-text', currentText);
    });

    // показ видео в попапе
    $('.colorbox-video').colorbox({
        iframe: true,
        innerWidth: 800,
        innerHeight: 480,
        opacity: '.8',
        className: 'video-popup'
    });

    // переключение языков. На паблике по идее не нужно будет, там ссылки будут (?)
    $('#footer div.languages li').on('click', function (e) {
        var $this = $(this),
          $langs = $this.closest('.languages'),
          $currentLang = $langs.find('.current i'),
          $newLangClass = $this.find('i').attr('class');

        $currentLang.attr('class', $newLangClass);
        $.dropDownMenu('hideDropDown');
        $langs.find('.cur-lang').removeClass('cur-lang');
        $this.addClass('cur-lang');
    });

    // placeholders
    $('div.placeholder-input').each(function () {
        var $input = $('input, textarea', this),
          $label = $('label', this),
          $that = $(this);

        if (!$input.data('defaultValue')) {
            $input.data('defaultValue', $label.text());
        }

        if ('' !== $input.val()) {
            $label.text('');
        }

        $input.on({
            focus: function () {
                $that.addClass('focus');
            },
            blur: function () {
                $that.removeClass('focus');
            },
            'keyup change': function () {
                if (0 < $(this).val().length) {
                    $label.text('');
                } else {
                    $label.text($(this).data('defaultValue'));
                }
            }
        });
    });

    // forgot password popup
    $('a.forgot-password-link').on('click', function (e) {
        $('#forgot_password_popup').dialog({
            modal: true,
            dialogClass: 'forgot-password-popup',
            width: '390',
            open: function () {
                $.dropDownMenu('hideDropDown');
                $('div.ui-widget-overlay')
                  .addClass('forgot-password-overlay')
                  .on('click', function () {
                      $('#forgot_password_popup').dialog('close');
                  });

                $('#forgot_password_popup input:text').focus();
            },
            close: function () {
                $('div.ui-widget-overlay').removeClass('forgot-password-overlay');
            }
        });

        e.preventDefault();
    });

    // sidebar registration advantages
    $('.advantage-items').on('click', 'div.header', function() {
        var $li = $(this).parent('li');

        if (!$li.hasClass('active')) {
            // hide other active
            $('.advantage-items li.active div.body').slideUp('fast', function() {
                $(this).closest('li.active').removeClass('active');
            });
        }

        $(this).next('div.body').slideToggle('fast', function() {
            $li.toggleClass('active');
        });
    });

    // checkbox подписки
    $('div.switch').on('click', function(e) {
        var $target = $(e.target),
            $checkbox = $(':checkbox', this),
            $checkboxWrapper = $('span.switch-checkbox', this),
            $leftLabel = $('span.switch-label:first', this),
            $rightLabel = $('span.switch-checkbox + span.switch-label', this);

        if ($target.is($checkboxWrapper) || $target.is('span.switch-label:not(".active")')) {
            $checkbox.prop('checked', !$checkbox.prop('checked'));
            $checkboxWrapper.toggleClass('checked');
            $leftLabel.toggleClass('active');
            $rightLabel.toggleClass('active');
        }
    });

    // Всплывающие подсказки
        // в шапке количество писем
    $('#navbar li.messages').tooltip({
        position: {
            my: "center bottom",
            at: "center+10 top-10",
            using: function( position, feedback ) {
                $( this ).css( position );
                $( "<div>" )
                  .addClass( 'arrow' )
                  .addClass( feedback.vertical )
                  .addClass( feedback.horizontal )
                  .appendTo( this );
            }
        },
        tooltipClass: 'message-notice',
        show: {
            delay: 400
        }
    });

        // история поиска, подсказка в правой колонке страницы
    $('.search-history-box, .order-composition').tooltip({
        position: {
            my: "left center",
            at: "left+24 center",
            using: function( position, feedback ) {
                $( this ).css( position );
                $( "<div>" )
                  .addClass( 'arrow' )
                  .addClass( feedback.vertical )
                  .addClass( feedback.horizontal )
                  .appendTo( this );
            }
        },
        tooltipClass: 'help-tooltip',
        show: {
            delay: 400
        }
    });

        // popup discounts tooltip
    $('div.order-info span.counts-discount').tooltip({
        position: {
            my: "center bottom",
            at: "center top-5",
            using: function( position, feedback ) {
                $( this ).css( position );
                $( "<div>" )
                  .addClass( 'arrow' )
                  .addClass( feedback.vertical )
                  .addClass( feedback.horizontal )
                  .appendTo( this );
            }
        },
        tooltipClass: 'tooltip-simple',
        show: {
            delay: 300
        }
    });

    $('div.table span.counts-discount, div.table i.icon-percent').tooltip({
        position: {
            my: "right center",
            at: "left-10 center",
            using: function( position, feedback ) {
                $( this ).css( position );
                $( "<div>" )
                  .addClass( 'arrow' )
                  .addClass( feedback.vertical )
                  .addClass( feedback.horizontal )
                  .appendTo( this );
            }
        },
        tooltipClass: 'tooltip-simple',
        show: {
            delay: 300
        }
    });

    // sidebar search history box
    $('div.search-history-box')
      .on('click',function (e) {
          var $target = $(e.target);

          // свернуть/развернуть
          if ($('div.collapse-link').has($target).length) {
              var $textNode = $('div.collapse-link > span span', this),
                oldText = $textNode.text(),
                $additionalList = $('div.history-body ul li:gt(5)', this);

              if ($(this).hasClass('collapsed')) {
                  $additionalList.show();
              } else {
                  $additionalList.hide();
              }

              $(this).toggleClass('collapsed');
              $textNode.text($textNode.attr('data-toggle-text'));
              $textNode.attr('data-toggle-text', oldText);
              $('div.collapse-link i.arrow', this).toggleClass('up');

              // при раскрытии списка у фиксированного блока не было видно нижней части
              $('aside.secondary div.sticky').data('plugin_sticky').winResize();
          }
      }).on('mouseenter', 'li', function () {
          var $modelDetail = $('div.model-detail', this),
            $this = $(this);
          $this.data('hover', true);
          setTimeout(function () {
              if ($this.data('hover')) {
                  $modelDetail.stop(true, true).fadeIn(300)
                    .css('margin-top', -($modelDetail.outerHeight() / 2));
              }
          }, 500);
      }).on('mouseleave', 'li', function () {
          $(this).data('hover', false);
          $('div.model-detail', this).fadeOut(300);

      });

    // смена брендов (для паблика, возможно, будет не нужно)
    var $brand = $('.brands-list span'),
      $brandHead = $('.catalogue-title-logo');

    $brand.on('click', function () {
        var $this = $(this),
          removedClass = $brandHead[0].className.match(/ logo-\w*/)[0],
          $dropdownList = $this.closest('.dropdown-list');
        if (!$this.hasClass('current')) {
            $brandHead
              .removeClass(removedClass)
              .addClass($this[0].className)
              .text($this.text());
            $brandHead.closest('.catalogue-title').removeClass('active');
            $dropdownList.hide();

            $dropdownList.find('.current').removeClass('current');
            $this.addClass('current');
        }
    });

    // смена категории (для паблика, возможно, будет не нужно)
    var $category = $('.categories-list span'),
      $categoryHead = $('.category-title .title');

    $category.on('click', function () {
        var $this = $(this),
          $dropdownList = $this.closest('.dropdown-list');
        $categoryHead.text($this.text());
        $categoryHead.closest('.catalogue-title').removeClass('active');
        $dropdownList.hide();
        $dropdownList.find('.current').removeClass('current');
        $this.addClass('current');
    });

    // collapse box
    $('div.collapse-box').on('click', function(e) {
        if (!$('div.collapse-link span.link', this).has($(e.target)).length) {
            return;
        }
        e.preventDefault();
        $(this).toggleClass('active');
        $('div.collapse-content', this).slideToggle('fast');
    });

    $('.add-new-basket').on('click', function (e) {
        e.preventDefault();
        $.dropDownMenu('hideDropDown');
        // закрыть popup если нужно
        var $dialog;

        if (($dialog = $('div.ui-dialog-content')).is(':visible')) {
            $dialog.dialog('close');
        }

        $('#navbar div.new-group').show();
    });

    // новая группа корзины
    // выбор цвета
    $('div.new-group').on('click', function(e) {
        e.stopPropagation();

        var $target = $(e.target),
          $colorsList = $('div.colors-list', this);

        // btn cancel
        if ($target.is($('div.actions span.dotted-red', this)) || $target.is('i.icon-close')) {
            $.dropDownMenu('hideDropDown');

            return;
        }

        if (!$('div.color-box', this).has($target).length) {
            if ($colorsList.is(':visible')) {
                $colorsList.hide();
            }

            return;
        }

        var $currentColor = $('div.current-color', this);

        if ($target.is($currentColor)) {
            $colorsList.show();
        }

        if ($target.is('div.colors-list li:not(".active")', this)) {
            $currentColor[0].className = $currentColor[0].className.replace(/\bbg-.*\b/, $target.attr('class'));

            var $activeColor = $('div.colors-list li.active', this),
              $activeDiv = $('div', $activeColor);

            $activeColor.removeClass('active');
            $target.addClass('active');
            $target.append($activeDiv);
            $colorsList.hide();
        }
    });

    // количество символов новой корзины
    $('div.new-group div.placeholder-input input').on('change keyup', function() {
        var maxLength = 22,
          lastChar = $(this).closest('div.row').find('div.hint span.chars');

        lastChar.text(maxLength - $(this).val().length);
    });

    // переключение контактной информации для городов
    $('.opb-city-link').on('click', function () {
        var $this = $(this),
          $links = $this.closest('.opb-cities').find('.opb-city-link'),
          $label = $this.closest('.opb-city-box').find('.opb-current-city');
        if (!$this.hasClass('current')) {
            var cityId = $this.attr('id').replace('_link', '');
            $links.removeClass('current');
            $this.addClass('current');
            $label.text($this.data('city'));
            $('.opb-body').removeClass('active');
            $('#' + cityId).addClass('active');
            $.dropDownMenu('hideDropDown');
        } else {
            $.dropDownMenu('hideDropDown');
        }
    });

    // подходит к моделям
    $('div.models-compatible div.compatible-brands').on('click', 'span:not(".active")', function(e) {
        var brandName = /\bcompatible-.+\b/.exec($(this)[0].className)[0];

        if (!brandName) {
            return;
        }

        var $parent = $(this).closest('div.models-compatible');
        $('div.compatible-brands span', $parent).removeClass('active');
        $(this).addClass('active');
        $('div.compatible-models', $parent).removeClass('active');
        $('div.' + brandName + '-models', $parent).addClass('active');
    });

    // ie7 table row z-index
    var ie7TableRowZIndex = 50;

    $('.lt-ie8 div.table div.table-body div.table-row').each(function() {
        $(this).css('z-index', ie7TableRowZIndex);
        ie7TableRowZIndex -= 1;
    });

    $('.lt-ie8 #sidebar div.search-history-box').on('mouseenter', 'li', function() {
        $('#sidebar').css('z-index', '98');
    }).on('mouseleave', 'li', function() {
          $('#sidebar').css('z-index', '1');
      });
});