;(function ($, window, document, undefined) {
    'use strict';

    var pluginName = 'sticky',
        defaults = {
            topSpacing: 50,
            bottomSpacing: 0,
            zIndex: 98
        };

    function Plugin(element, options) {
        this.$element = $(element);

        this.options = $.extend({}, defaults, options);

        this.init();
    }

    Plugin.prototype = {
        init: function () {
            this.$win = $(window);
            this.elementWidth = this.$element.outerWidth();
            this.elementHeight = this.$element.outerHeight();
            this.elementTopStop = this.$element.offset().top - this.options.topSpacing;
            this.winResize();
            this.$spacer = $('<div class="h-sticky"></div>').insertAfter(this.$element);

            this.$win.on({
                'scroll load': $.proxy(this.scroller, this),
                'resize': $.proxy(this.winResize, this)
            });

            function appendContent($div, content) {
                $div.append(content).trigger($.Event('resize'));
            }
        },

        scroller: function () {
            if (!this.stickable) {
                this.$element.css({
                    'position': '',
                    'top': '',
                    'width': '',
                    'z-index': ''
                }).removeClass('is-sticky');
                this.$spacer.css('height', '');
                return;
            }

            var scrollTop = this.$win.scrollTop();

            if (scrollTop <= this.elementTopStop) {
                this.$element.css({
                    'position': '',
                    'top': '',
                    'width': '',
                    'z-index': ''
                }).removeClass('is-sticky');
                this.$spacer.css('height', '');
            } else {
                this.$element.css({
                    'position': 'fixed',
                    'top': this.options.topSpacing,
                    'width': this.elementWidth,
                    'z-index': this.options.zIndex
                }).addClass('is-sticky');
                this.$spacer.css('height', this.elementHeight);
            }
        },

        // если блок не вмещается в высоту окна - отключить фиксацию
        winResize: function () {
            if (this.$win.height() - this.options.topSpacing < this.$element.outerHeight()) {
                this.stickable = false;
            } else {
                this.stickable = true;
            }
        }
    };

    $.fn[pluginName] = function (options) {
        return this.each(function () {
            if (!$.data(this, 'plugin_' + pluginName)) {
                $.data(this, 'plugin_' + pluginName, new Plugin(this, options));
            }
        });
    };

})(jQuery, window, document);