/**
 * Обработка формы регистрации
 */
(function () {

    var defaults = {
        length: {       // минимальные допустимые длины полей
            house: 1,   // длина номера дома
            text: 2     // длина текстовго поля (имя, фамилия)
        },
        hintBlock: '#company-empty-fields',
        completeHint: '#company-form-complete',
        submit: '#company_btn'
    };
    var options = {};

    var methods = {
        /**
         * Инизиализация плагина
         * @param params
         */
        init: function (params) {
            options = $.extend(options, defaults, params);
            options.form = this;
            options.hintBlock = $(options.hintBlock);
            options.fields = options.form.find('.check-field');
            options.requiredFields = options.form.find('.required');
            options.errorCounter = 0;
            options.submit = $(options.submit);
            options.completeHint = $(options.completeHint);

            methods.createHints();
            options.fields
                .on('change', function (e) {
                    var $this = $(this),
                        validateType = $this.data('validate');

                    methods.clearLabelStatus($(this));

                    switch (validateType) {
                        case 'email' :
                            methods.checkEmail($this);
                            break;

                        case 'phone' :
                            methods.checkPhone($this);
                            break;

                        case 'house' :
                            methods.checkHouse($this);
                            break;

                        default :
                            methods.checkTextField($this);
                            break;
                    }
                });

            options.form
                .submit(function (e) {
                    e.preventDefault(); // отмена действия по умолчанию
                    methods.sendStatus();
                    // по ответу от сервера используем
//                    methods.waitStatus();
                });
        },

        /**
         * Наполнение блока с подсказками для обязательно заполняемых полей
         */
        createHints: function () {
            options.errorCounter = 0;
            options.hintBlock.empty();

            options.requiredFields
                .each(function () {
                    var $this = $(this);

                    if (!$this.data('checked')) {
                        var $label = $('<label />', {
                            for: $this.attr('id'),
                            class: 'label-hint',
                            text: $this.data('required')
                        });

                        var coma = options.errorCounter > 0 ? ', ' : '';
                        options.hintBlock.append(coma, $label);
                        options.errorCounter++;
                    }
                });

            if (options.errorCounter > 0) {
                options.hintBlock.closest('.fields-errors').stop(true, false).fadeIn();
                methods.disableSubmit();
            } else {
                options.hintBlock.closest('.fields-errors').stop(true, false).fadeOut();
                methods.enableSubmit();
            }
        },

        /**
         * проверка поля email
         * @param el
         */
        checkEmail: function (el) {
            var val = el.val();

            if (!privateMethods._emailField(val)) {
                methods.failedCheckedLabel(el);
                privateMethods._errorContent(el, 'Некорректный адрес электронной почты');
            } else {
                methods.successCheckedLabel(el);
            }
        },

        /**
         * проверка текстового поля (имя, фамилия)
         * @param el
         */
        checkTextField: function(el) {
            var val = el.val();

            if (val.length >= options.length.text) {
                methods.successCheckedLabel(el);
            } else {
                methods.failedCheckedLabel(el);
                privateMethods._errorContent(el, 'Слишком короткое значение');
            }
        },

        /**
         * проверка ввода номера телефона
         * @param el
         */
        checkPhone: function (el) {
            var val = el.val();

            if (val.length > 0) {
                if (!privateMethods._phoneField(val)) {
                    methods.failedCheckedLabel(el);
                    privateMethods._errorContent(el, 'Проверьте формат введенного номера телефона - (XX) X-X-X');
                } else {
                    methods.successCheckedLabel(el);
                }
            }
        },

        /**
         * проверка ввода номера дома
         * @param el
         */
        checkHouse: function (el) {
            var val = el.val();

            if (val.length >= options.length.house) {
                methods.successCheckedLabel(el);
            } else {
                methods.failedCheckedLabel(el);
                privateMethods._errorContent(el, 'Слишком короткое значение');
            }
        },

        enableSubmit: function () {
            options.submit.attr('disabled', false);
            options.completeHint.show();
        },

        disableSubmit: function () {
            options.submit.attr('disabled', true);
            options.completeHint.hide();
        },

        sendStatus: function () {
            options.fields.attr('readonly', true);
            options.submitWrapper.addClass('sending');
            options.sendStatus.show();
        },

        waitStatus: function () {
            options.fields.attr('readonly', false);
            options.submitWrapper.removeClass('sending');
            options.sendStatus.hide();
        },

        /**
         * показываем индикатор загрузки
         * @param el
         */
        showSpinner: function (el) {
            el.closest('.placeholder-input').addClass('spinner');
        },

        /**
         * скрываем индикатор загрузки
         * @param el
         */
        hideSpinner: function (el) {
            el.closest('.placeholder-input').removeClass('spinner');
        },

        /**
         * изменение статуса поля, которое прошло валидацию
         * @param el
         */
        successCheckedLabel: function (el) {
            el.closest('.placeholder-input').addClass('checked');
            el.data('checked', true);
            methods.createHints();
        },

        /**
         * изменение статуса поля, которое не прошло валидацию
         * @param el
         */
        failedCheckedLabel: function (el) {
            el.closest('.placeholder-input').addClass('error-icon error');
            el.data('checked', false);
            methods.createHints();
        },

        /**
         * очистка статуса поля
         * @param el
         */
        clearLabelStatus: function (el) {
            el.closest('.placeholder-input').removeClass('checked error-icon error');
            el.data('checked', false);
            el.closest('.placeholder-input').find('.error-field-text .wrapper').empty();
            el.closest('.placeholder-input').find('.error-field-text').hide();
        }
    };

    var privateMethods = {
        _errorContent: function (el, error) {
            el.closest('.placeholder-input').find('.error-field-text .wrapper').text(error);
            el.closest('.placeholder-input').find('.error-field-text').show();
        },

        _digitField: function (value) {
            var pattern = "(\\d{" + options.length.inn + ",})",
                regexp = new RegExp(pattern);
            return regexp.test(value);
        },

        _emailField: function (value) {
            var regexp = new RegExp(/^(("[\w-\s]+")|([\w-]+(?:\.[\w-]+)*)|("[\w-\s]+")([\w-]+(?:\.[\w-]+)*))(@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$)|(@\[?((25[0-5]\.|2[0-4][0-9]\.|1[0-9]{2}\.|[0-9]{1,2}\.))((25[0-5]|2[0-4][0-9]|1[0-9]{2}|[0-9]{1,2})\.){2}(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[0-9]{1,2})\]?$)/ig);
            return regexp.test(value);
        },

        _phoneField: function (value) {
            var regexp = new RegExp(/((\+\d{1,})\s|())(\(\d{2,}\))\s(\d{1,})-(\d{1,})-(\d{1,})/);
            return regexp.test(value);
        }
    };

    $.fn.personAuthForm = function (method) {
        if (methods[method]) {
            return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
        } else if (typeof method == 'object' || !method) {
            return methods.init.apply(this, arguments);
        } else {
            $.error('Плагин применен с некорректными параметрами');
        }
    };
})(jQuery);